<?php

declare(strict_types=1);

namespace App\Admin;

final class Security
{
    public static function sendHeaders(string $nonce): void
    {
        header('X-Content-Type-Options: nosniff');
        header('Referrer-Policy: no-referrer');
        header('X-Frame-Options: DENY');
        header('Permissions-Policy: geolocation=(), microphone=(), camera=()');
        header('Cross-Origin-Opener-Policy: same-origin');
        header('Cross-Origin-Resource-Policy: same-site');

        if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
            header('Strict-Transport-Security: max-age=31536000; includeSubDomains; preload');
        }

        header('Cache-Control: no-store, max-age=0');
        header('Pragma: no-cache');

        $csp = "default-src 'none'; "
            . "img-src 'self' https: data:; "
            . "style-src 'self'; "
            . "script-src 'nonce-{$nonce}'; "
            . "connect-src 'self'; "
            . "base-uri 'none'; "
            . "form-action 'self'; "
            . "frame-ancestors 'none'";

        header('Content-Security-Policy: ' . $csp);
    }
}
