<?php

declare(strict_types=1);

namespace App\IpIntel;

final class BlackboxClient
{
    private const DEFAULT_BASE_URL = 'https://blackbox.ipinfo.app';

    public function __construct(
        private readonly HttpClientInterface $http,
        private readonly string $baseUrl = self::DEFAULT_BASE_URL,
        private readonly int $timeoutSeconds = 3
    ) {
    }

    /**
     * API v1: returns 'Y' | 'N' | 'E'
     */
    public function check(string $ip): string
    {
        $ip = IpValidator::assertValidIp($ip);

        $url = rtrim($this->baseUrl, '/') . '/api/v1/' . rawurlencode($ip);

        $resp = $this->http->get($url, [
            'Accept' => 'text/plain',
        ], $this->timeoutSeconds);

        if ($resp->statusCode !== 200) {
            return 'E';
        }

        $v = strtoupper(trim($resp->body));
        if ($v === 'Y' || $v === 'N' || $v === 'E') {
            return $v;
        }

        return 'E';
    }
}
