<?php

declare(strict_types=1);

namespace App\IpIntel;

final class Cidr
{
    public static function isValid(string $cidr): bool
    {
        $cidr = trim($cidr);
        $parts = explode('/', $cidr);
        if (count($parts) !== 2) {
            return false;
        }

        [$ip, $mask] = $parts;

        if (filter_var($ip, FILTER_VALIDATE_IP) === false) {
            return false;
        }

        if (!ctype_digit($mask)) {
            return false;
        }

        $m = (int) $mask;

        $isV6 = str_contains($ip, ':');
        if ($isV6) {
            return $m >= 0 && $m <= 128;
        }

        return $m >= 0 && $m <= 32;
    }
}
