<?php

declare(strict_types=1);

namespace App\IpIntel;

use InvalidArgumentException;

final class IpValidator
{
    public static function assertValidIp(string $ip): string
    {
        $ip = trim($ip);

        if ($ip === '' || filter_var($ip, FILTER_VALIDATE_IP) === false) {
            throw new InvalidArgumentException('Invalid IP address');
        }

        return $ip;
    }
}
