#!/usr/bin/env bash

# Redis Startup Script
# Usage: ./bin/redis-start.sh

set -e

echo "Starting Redis server..."

# Check if Redis is already running
if redis-cli ping > /dev/null 2>&1; then
    echo "✅ Redis is already running"
    redis-cli INFO server | grep redis_version
    exit 0
fi

# Start Redis in background
echo "Starting Redis server in background..."
redis-server --daemonize yes \
    --dir "$(pwd)/data/redis" \
    --logfile "$(pwd)/data/logs/redis.log" \
    --maxmemory 256mb \
    --maxmemory-policy allkeys-lru \
    2>&1

# Wait for Redis to start
sleep 2

# Test connection
if redis-cli ping > /dev/null 2>&1; then
    echo "✅ Redis started successfully"
    redis-cli INFO server | grep -E "redis_version|uptime_in_seconds"
else
    echo "❌ Failed to start Redis"
    exit 1
fi
