/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: gradakan_gogens
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB-cll-lve-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `global_domains`
--

DROP TABLE IF EXISTS `global_domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL COMMENT 'Full domain name (e.g., go.link)',
  `provider` enum('cpanel','cloudflare') NOT NULL DEFAULT 'cloudflare',
  `is_wildcard` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable wildcard DNS (*.domain)',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `is_default` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Default domain for new shortlinks',
  `cpanel_host` varchar(255) DEFAULT NULL,
  `cpanel_username` varchar(100) DEFAULT NULL,
  `cpanel_token` text DEFAULT NULL COMMENT 'Encrypted',
  `cf_zone_id` varchar(100) DEFAULT NULL,
  `cf_api_token` text DEFAULT NULL COMMENT 'Encrypted',
  `cf_proxied` tinyint(1) DEFAULT 0,
  `dns_record_id` varchar(100) DEFAULT NULL,
  `target_ip` varchar(45) DEFAULT NULL,
  `target_cname` varchar(255) DEFAULT NULL,
  `last_sync_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_domain` (`domain`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_is_default` (`is_default`),
  KEY `idx_provider` (`provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Global domains accessible to all users';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_domains`
--

LOCK TABLES `global_domains` WRITE;
/*!40000 ALTER TABLE `global_domains` DISABLE KEYS */;
/*!40000 ALTER TABLE `global_domains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `key` varchar(100) NOT NULL,
  `value` text NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Application configuration settings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES
('default_locale','id_ID','2025-12-23 21:59:55'),
('default_og_type','website','2025-12-23 21:59:55'),
('default_site_name','OG Shortlink','2025-12-23 21:59:55'),
('redirect_url','','2025-12-23 21:59:55');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shortlinks`
--

DROP TABLE IF EXISTS `shortlinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shortlinks` (
  `code` varchar(100) NOT NULL COMMENT 'Unique shortlink code',
  `domain` varchar(255) DEFAULT NULL COMMENT 'Associated domain (NULL = default)',
  `og_title` varchar(500) NOT NULL,
  `og_description` text NOT NULL,
  `og_image_url` varchar(1000) DEFAULT '',
  `og_type` varchar(50) DEFAULT 'website',
  `og_site_name` varchar(255) DEFAULT '',
  `og_locale` varchar(10) DEFAULT 'id_ID',
  `domain_type` enum('global','user') DEFAULT NULL COMMENT 'Domain type: global or user',
  `domain_id` bigint(20) unsigned DEFAULT NULL COMMENT 'Reference to global_domains.id or user_domains.id',
  `use_shim` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable shim link wrapper for this shortlink',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`code`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_domain_active` (`domain`,`is_active`),
  KEY `idx_use_shim` (`use_shim`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_domain_type` (`domain_type`),
  KEY `idx_domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Shortlink codes with OpenGraph metadata';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shortlinks`
--

LOCK TABLES `shortlinks` WRITE;
/*!40000 ALTER TABLE `shortlinks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shortlinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `traffic_analytics`
--

DROP TABLE IF EXISTS `traffic_analytics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `traffic_analytics` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shortlink_id` bigint(20) unsigned DEFAULT NULL COMMENT 'MUST match shortlinks.id type exactly',
  `shortlink_code` varchar(50) NOT NULL,
  `target_url` text NOT NULL,
  `redirect_url` text DEFAULT NULL,
  `ip_bin` varbinary(16) NOT NULL COMMENT 'Store inet_pton(ip); 4 bytes IPv4, 16 bytes IPv6',
  `ip_text` varchar(45) GENERATED ALWAYS AS (inet6_ntoa(`ip_bin`)) STORED,
  `ip_is_v6` tinyint(1) GENERATED ALWAYS AS (case when octet_length(`ip_bin`) = 16 then 1 else 0 end) STORED,
  `country_code` char(2) DEFAULT NULL,
  `country_name` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `continent_code` char(2) DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `asn` int(10) unsigned DEFAULT NULL,
  `asn_org` varchar(255) DEFAULT NULL,
  `isp` varchar(255) DEFAULT NULL,
  `is_vpn` tinyint(1) NOT NULL DEFAULT 0,
  `is_proxy` tinyint(1) NOT NULL DEFAULT 0,
  `is_tor` tinyint(1) NOT NULL DEFAULT 0,
  `is_datacenter` tinyint(1) NOT NULL DEFAULT 0,
  `risk_score` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'App should keep this 0..100',
  `blackbox_signal` enum('Y','N','E') DEFAULT NULL,
  `device_type` enum('mobile','tablet','desktop','bot','unknown') NOT NULL DEFAULT 'unknown',
  `device_brand` varchar(50) DEFAULT NULL,
  `device_model` varchar(100) DEFAULT NULL,
  `browser_name` varchar(50) DEFAULT NULL,
  `browser_version` varchar(50) DEFAULT NULL,
  `os_name` varchar(50) DEFAULT NULL,
  `os_version` varchar(50) DEFAULT NULL,
  `platform` varchar(50) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `is_bot` tinyint(1) NOT NULL DEFAULT 0,
  `bot_name` varchar(100) DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `http_method` enum('GET','POST','HEAD','PUT','DELETE','OPTIONS','PATCH') NOT NULL DEFAULT 'GET',
  `http_protocol` enum('HTTP/1.0','HTTP/1.1','HTTP/2','HTTP/3') DEFAULT NULL,
  `visited_at` datetime(6) NOT NULL DEFAULT current_timestamp(6),
  `response_time_ms` int(10) unsigned DEFAULT NULL COMMENT 'Response time in milliseconds',
  PRIMARY KEY (`id`),
  KEY `idx_shortlink_code_visited` (`shortlink_code`,`visited_at`),
  KEY `idx_visited_shortlink` (`visited_at`,`shortlink_code`),
  KEY `idx_ip_bin` (`ip_bin`),
  KEY `idx_visited_country` (`visited_at`,`country_code`),
  KEY `idx_visited_device` (`visited_at`,`device_type`),
  KEY `idx_is_bot_visited` (`is_bot`,`visited_at`),
  KEY `idx_risk_visited` (`risk_score`,`visited_at`),
  KEY `idx_shortlink_id` (`shortlink_id`),
  KEY `idx_visited_at` (`visited_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Traffic analytics and monitoring data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `traffic_analytics`
--

LOCK TABLES `traffic_analytics` WRITE;
/*!40000 ALTER TABLE `traffic_analytics` DISABLE KEYS */;
/*!40000 ALTER TABLE `traffic_analytics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `traffic_summary_daily`
--

DROP TABLE IF EXISTS `traffic_summary_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `traffic_summary_daily` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shortlink_code` varchar(50) NOT NULL,
  `summary_date` date NOT NULL,
  `total_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `unique_ips` int(10) unsigned NOT NULL DEFAULT 0,
  `bot_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `mobile_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `desktop_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `tablet_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `risky_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `vpn_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `proxy_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `tor_visits` int(10) unsigned NOT NULL DEFAULT 0,
  `top_countries` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '{"US": 100, "ID": 50}' CHECK (json_valid(`top_countries`)),
  `top_devices` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '{"iPhone": 50, "Samsung": 30}' CHECK (json_valid(`top_devices`)),
  `top_browsers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '{"Chrome": 80, "Safari": 20}' CHECK (json_valid(`top_browsers`)),
  `top_referrers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT '{"facebook.com": 100}' CHECK (json_valid(`top_referrers`)),
  `avg_response_time_ms` int(10) unsigned DEFAULT NULL,
  `created_at` datetime(6) NOT NULL DEFAULT current_timestamp(6),
  `updated_at` datetime(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_shortlink_date` (`shortlink_code`,`summary_date`),
  KEY `idx_summary_date` (`summary_date`),
  KEY `idx_summary_shortlink` (`shortlink_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='Daily summary for faster dashboard queries';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `traffic_summary_daily`
--

LOCK TABLES `traffic_summary_daily` WRITE;
/*!40000 ALTER TABLE `traffic_summary_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `traffic_summary_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_domains`
--

DROP TABLE IF EXISTS `user_domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `domain` varchar(255) NOT NULL COMMENT 'Full domain name (e.g., short.example.com)',
  `provider` enum('cpanel','cloudflare') NOT NULL DEFAULT 'cloudflare',
  `is_wildcard` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable wildcard DNS (*.domain)',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `cpanel_host` varchar(255) DEFAULT NULL COMMENT 'cPanel hostname',
  `cpanel_username` varchar(100) DEFAULT NULL COMMENT 'cPanel username',
  `cpanel_token` text DEFAULT NULL COMMENT 'cPanel API token (encrypted)',
  `cf_zone_id` varchar(100) DEFAULT NULL COMMENT 'Cloudflare zone ID',
  `cf_api_token` text DEFAULT NULL COMMENT 'Cloudflare API token (encrypted)',
  `cf_proxied` tinyint(1) DEFAULT 0 COMMENT 'Enable Cloudflare proxy (orange cloud)',
  `dns_record_id` varchar(100) DEFAULT NULL COMMENT 'DNS record ID (for updates/deletes)',
  `target_ip` varchar(45) DEFAULT NULL COMMENT 'Target IP address for A record',
  `target_cname` varchar(255) DEFAULT NULL COMMENT 'Target CNAME for CNAME record',
  `last_sync_at` timestamp NULL DEFAULT NULL COMMENT 'Last DNS sync timestamp',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_user_domain` (`user_id`,`domain`),
  KEY `idx_user_active` (`user_id`,`is_active`),
  KEY `idx_provider` (`provider`),
  KEY `idx_is_wildcard` (`is_wildcard`),
  CONSTRAINT `user_domains_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='User-owned domains for shortlink service';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_domains`
--

LOCK TABLES `user_domains` WRITE;
/*!40000 ALTER TABLE `user_domains` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_domains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL COMMENT 'Login username',
  `password_hash` varchar(255) NOT NULL COMMENT 'bcrypt hash',
  `name` varchar(255) NOT NULL COMMENT 'Display name',
  `role` enum('admin','user') NOT NULL DEFAULT 'user',
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_username` (`username`),
  KEY `idx_role_active` (`role`,`is_active`),
  KEY `idx_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='User authentication and authorization';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(1,'admin','$2y$10$yJELl/wNlrXNg.COnQ9ehuaBhfQtO8Mw9705pxi1/K/r0e2313MrC','admin','admin',1,'2025-12-22 10:04:28','2025-12-22 10:04:28');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'gradakan_gogens'
--

--
-- Dumping routines for database 'gradakan_gogens'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-23 22:47:21
