<?php
declare(strict_types=1);
/**
 * Step 5: Installation Complete
 * @var string $baseUrl
 * @var string $cronInstructions
 */
?>
<div class="complete-icon">&#10003;</div>
<h2 class="complete-title">Installation Complete!</h2>
<p class="complete-message">OG Shortlink has been successfully installed.</p>

<div class="alert alert-success">
    Your shortlink service is ready to use. The installer files have been removed for security.
</div>

<div class="info-box">
    <h4>Quick Links</h4>
    <ul class="link-list">
        <li><a href="<?= htmlspecialchars($baseUrl) ?>/admin/" target="_blank">Admin Panel &rarr;</a></li>
        <li><a href="<?= htmlspecialchars($baseUrl) ?>/" target="_blank">Homepage &rarr;</a></li>
    </ul>
</div>

<div class="info-box">
    <h4>Important: Set Up Cron Jobs</h4>
    <p>Add these cron jobs in cPanel for optimal performance:</p>
</div>

<div class="code-block"><?= htmlspecialchars($cronInstructions) ?></div>

<div class="info-box">
    <h4>Next Steps</h4>
    <ul class="link-list" style="list-style: decimal; padding-left: 1.5rem;">
        <li>Login to the admin panel with your new credentials</li>
        <li>Configure your global redirect URL in Settings</li>
        <li>Add your first domain (optional)</li>
        <li>Create your first shortlink</li>
        <li>Set up the cron jobs shown above</li>
    </ul>
</div>

<div class="security-notice">
    <h4>Security Reminders</h4>
    <p>
        &#8226; Keep your .env file secure (chmod 600)<br>
        &#8226; Set up SSL/HTTPS for your domain<br>
        &#8226; Regularly backup your database<br>
        &#8226; Keep PHP and dependencies updated
    </p>
</div>

<div class="btn-group" style="justify-content: center;">
    <a href="<?= htmlspecialchars($baseUrl) ?>/admin/" class="btn btn-primary">
        Go to Admin Panel &rarr;
    </a>
</div>
