<?php
declare(strict_types=1);
/**
 * Installer Layout Template
 * @var int $currentStep
 * @var string $content
 */
$steps = [
    1 => 'Requirements',
    2 => 'Database',
    3 => 'Settings',
    4 => 'Admin',
    5 => 'Complete',
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Install - OG Shortlink</title>
    <link rel="stylesheet" href="assets/installer.css">
</head>
<body>
    <div class="installer-container">
        <div class="installer-card">
            <div class="installer-header">
                <h1>OG Shortlink Installer</h1>
                <p>Production Setup for cPanel Shared Hosting</p>
            </div>

            <div class="installer-body">
                <?php if ($currentStep < 5): ?>
                <div class="progress-steps">
                    <?php foreach ($steps as $num => $label): ?>
                        <?php if ($num <= 4): ?>
                        <div class="step <?= $num < $currentStep ? 'completed' : ($num === $currentStep ? 'active' : '') ?>">
                            <div class="step-number">
                                <?= $num < $currentStep ? '&#10003;' : $num ?>
                            </div>
                            <div class="step-label"><?= htmlspecialchars($label) ?></div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <?= $content ?>
            </div>
        </div>

        <p style="text-align: center; color: rgba(255,255,255,0.7); margin-top: 1.5rem; font-size: 0.875rem;">
            OG Shortlink &copy; <?= date('Y') ?> - Secure URL Shortener
        </p>
    </div>

    <script>
    // Test database connection
    function testConnection() {
        const btn = document.getElementById('test-btn');
        const status = document.getElementById('connection-status');
        const form = document.getElementById('db-form');

        btn.disabled = true;
        btn.innerHTML = '<span class="loading"></span> Testing...';
        status.className = 'connection-status';
        status.innerHTML = '';
        status.style.display = 'none';

        const formData = new FormData(form);
        formData.append('action', 'test_db');

        fetch('', {
            method: 'POST',
            body: formData
        })
        .then(r => r.json())
        .then(data => {
            status.style.display = 'flex';
            if (data.success) {
                status.className = 'connection-status success';
                status.innerHTML = '&#10003; ' + data.message;
                document.getElementById('submit-btn').disabled = false;
            } else {
                status.className = 'connection-status error';
                status.innerHTML = '&#10007; ' + data.message;
                document.getElementById('submit-btn').disabled = true;
            }
        })
        .catch(err => {
            status.style.display = 'flex';
            status.className = 'connection-status error';
            status.innerHTML = '&#10007; Connection error';
        })
        .finally(() => {
            btn.disabled = false;
            btn.innerHTML = 'Test Connection';
        });
    }

    // Password visibility toggle
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        input.type = input.type === 'password' ? 'text' : 'password';
    }

    // Password strength checker
    function checkPasswordStrength(password) {
        let strength = 0;
        if (password.length >= 8) strength++;
        if (password.length >= 12) strength++;
        if (/[A-Z]/.test(password)) strength++;
        if (/[a-z]/.test(password)) strength++;
        if (/[0-9]/.test(password)) strength++;
        if (/[^A-Za-z0-9]/.test(password)) strength++;
        return strength;
    }

    // Form validation
    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('form');
        forms.forEach(form => {
            form.addEventListener('submit', function(e) {
                const submitBtn = form.querySelector('button[type="submit"]');
                if (submitBtn && !submitBtn.disabled) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="loading"></span> Processing...';
                }
            });
        });
    });
    </script>
</body>
</html>
