<?php
declare(strict_types=1);
/**
 * Step 1: System Requirements Check
 * @var array $requirements
 */
?>
<h2 class="section-title">System Requirements</h2>

<?php if (!$requirements['passed']): ?>
<div class="alert alert-danger">
    Some requirements are not met. Please fix the issues marked in red before continuing.
</div>
<?php else: ?>
<div class="alert alert-success">
    All requirements are met! You can proceed with the installation.
</div>
<?php endif; ?>

<ul class="requirements-list">
    <?php foreach ($requirements['checks'] as $key => $check): ?>
    <li class="requirement-item <?= $check['status'] ?>">
        <span class="requirement-icon">
            <?php if ($check['status'] === 'pass'): ?>&#10003;<?php elseif ($check['status'] === 'fail'): ?>&#10007;<?php else: ?>!<?php endif; ?>
        </span>
        <span><?= htmlspecialchars($check['message']) ?></span>
    </li>
    <?php endforeach; ?>
</ul>

<form method="post" action="">
    <input type="hidden" name="step" value="1">
    <input type="hidden" name="action" value="next">

    <div class="btn-group">
        <div></div>
        <button type="submit" class="btn btn-primary" <?= !$requirements['passed'] ? 'disabled' : '' ?>>
            Continue &rarr;
        </button>
    </div>
</form>
