<?php
declare(strict_types=1);
/**
 * Step 2: Database Configuration
 * @var string|null $error
 */
?>
<h2 class="section-title">Database Configuration</h2>

<?php if (!empty($error)): ?>
<div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="alert alert-info">
    Create a MySQL database in cPanel before proceeding. You'll need the database name, username, and password.
</div>

<form method="post" action="" id="db-form">
    <input type="hidden" name="step" value="2">
    <input type="hidden" name="action" value="next">

    <div class="form-row">
        <div class="form-group">
            <label class="form-label" for="db_host">Database Host</label>
            <input type="text" class="form-input" id="db_host" name="db_host"
                   value="<?= htmlspecialchars($_POST['db_host'] ?? 'localhost') ?>" required>
            <p class="form-hint">Usually "localhost" for cPanel</p>
        </div>

        <div class="form-group">
            <label class="form-label" for="db_port">Port</label>
            <input type="number" class="form-input" id="db_port" name="db_port"
                   value="<?= htmlspecialchars($_POST['db_port'] ?? '3306') ?>" required>
            <p class="form-hint">Default: 3306</p>
        </div>
    </div>

    <div class="form-group">
        <label class="form-label" for="db_name">Database Name</label>
        <input type="text" class="form-input" id="db_name" name="db_name"
               value="<?= htmlspecialchars($_POST['db_name'] ?? '') ?>" required
               placeholder="cpanelusername_dbname">
        <p class="form-hint">The database must already exist in cPanel</p>
    </div>

    <div class="form-row">
        <div class="form-group">
            <label class="form-label" for="db_user">Database Username</label>
            <input type="text" class="form-input" id="db_user" name="db_user"
                   value="<?= htmlspecialchars($_POST['db_user'] ?? '') ?>" required
                   placeholder="cpanelusername_user">
        </div>

        <div class="form-group">
            <label class="form-label" for="db_pass">Database Password</label>
            <input type="password" class="form-input" id="db_pass" name="db_pass"
                   value="<?= htmlspecialchars($_POST['db_pass'] ?? '') ?>" required>
        </div>
    </div>

    <div class="test-connection">
        <button type="button" class="btn btn-secondary" id="test-btn" onclick="testConnection()">
            Test Connection
        </button>
        <div id="connection-status" class="connection-status" style="display: none;"></div>
    </div>

    <div class="btn-group">
        <a href="?step=1" class="btn btn-secondary">&larr; Back</a>
        <button type="submit" class="btn btn-primary" id="submit-btn" disabled>
            Install Database &rarr;
        </button>
    </div>
</form>

<div class="security-notice">
    <h4>cPanel Database Setup</h4>
    <p>
        1. Login to cPanel &rarr; MySQL Databases<br>
        2. Create a new database<br>
        3. Create a new user with a strong password<br>
        4. Add user to database with ALL PRIVILEGES<br>
        5. Enter the details above
    </p>
</div>
