<?php
declare(strict_types=1);
/**
 * Step 3: Application Settings
 * @var array $keys
 * @var string $baseUrl
 * @var string|null $error
 */
?>
<h2 class="section-title">Application Settings</h2>

<?php if (!empty($error)): ?>
<div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="alert alert-success">
    Database installed successfully! Now configure your application settings.
</div>

<form method="post" action="">
    <input type="hidden" name="step" value="3">
    <input type="hidden" name="action" value="next">

    <!-- Carry forward DB settings -->
    <input type="hidden" name="db_host" value="<?= htmlspecialchars($_POST['db_host'] ?? $_SESSION['db_host'] ?? '') ?>">
    <input type="hidden" name="db_port" value="<?= htmlspecialchars($_POST['db_port'] ?? $_SESSION['db_port'] ?? '') ?>">
    <input type="hidden" name="db_name" value="<?= htmlspecialchars($_POST['db_name'] ?? $_SESSION['db_name'] ?? '') ?>">
    <input type="hidden" name="db_user" value="<?= htmlspecialchars($_POST['db_user'] ?? $_SESSION['db_user'] ?? '') ?>">
    <input type="hidden" name="db_pass" value="<?= htmlspecialchars($_POST['db_pass'] ?? $_SESSION['db_pass'] ?? '') ?>">

    <div class="form-group">
        <label class="form-label" for="base_url">Site URL</label>
        <input type="url" class="form-input" id="base_url" name="base_url"
               value="<?= htmlspecialchars($_POST['base_url'] ?? $baseUrl) ?>" required
               placeholder="https://yourdomain.com">
        <p class="form-hint">Your shortlink domain (with https://)</p>
    </div>

    <div class="info-box">
        <h4>Security Keys (Auto-Generated)</h4>
        <p>These secure keys have been automatically generated. You can change them if needed.</p>
    </div>

    <div class="form-group">
        <label class="form-label" for="session_secret">Session Secret</label>
        <input type="text" class="form-input" id="session_secret" name="session_secret"
               value="<?= htmlspecialchars($_POST['session_secret'] ?? $keys['session_secret']) ?>" required
               style="font-family: monospace; font-size: 0.8rem;">
    </div>

    <div class="form-group">
        <label class="form-label" for="api_key">API Key</label>
        <input type="text" class="form-input" id="api_key" name="api_key"
               value="<?= htmlspecialchars($_POST['api_key'] ?? $keys['api_key']) ?>" required
               style="font-family: monospace; font-size: 0.8rem;">
        <p class="form-hint">Used for external API access</p>
    </div>

    <!-- Hidden keys -->
    <input type="hidden" name="encryption_key" value="<?= htmlspecialchars($_POST['encryption_key'] ?? $keys['encryption_key']) ?>">
    <input type="hidden" name="url_sign_secret" value="<?= htmlspecialchars($_POST['url_sign_secret'] ?? $keys['url_sign_secret']) ?>">

    <div class="btn-group">
        <a href="?step=2" class="btn btn-secondary">&larr; Back</a>
        <button type="submit" class="btn btn-primary">
            Save Settings &rarr;
        </button>
    </div>
</form>
