<?php
declare(strict_types=1);
/**
 * Step 4: Admin User Setup
 * @var string|null $error
 */
?>
<h2 class="section-title">Create Admin Account</h2>

<?php if (!empty($error)): ?>
<div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="alert alert-info">
    Create your administrator account. This will be used to login to the admin panel.
</div>

<form method="post" action="">
    <input type="hidden" name="step" value="4">
    <input type="hidden" name="action" value="next">

    <div class="form-group">
        <label class="form-label" for="admin_name">Display Name</label>
        <input type="text" class="form-input" id="admin_name" name="admin_name"
               value="<?= htmlspecialchars($_POST['admin_name'] ?? 'Administrator') ?>" required
               placeholder="Your Name">
    </div>

    <div class="form-group">
        <label class="form-label" for="admin_username">Username</label>
        <input type="text" class="form-input" id="admin_username" name="admin_username"
               value="<?= htmlspecialchars($_POST['admin_username'] ?? '') ?>" required
               placeholder="admin" autocomplete="username"
               pattern="[a-zA-Z0-9_]{3,50}">
        <p class="form-hint">3-50 characters, letters, numbers, and underscores only</p>
    </div>

    <div class="form-row">
        <div class="form-group">
            <label class="form-label" for="admin_password">Password</label>
            <input type="password" class="form-input" id="admin_password" name="admin_password"
                   required minlength="8" autocomplete="new-password"
                   placeholder="Min. 8 characters">
        </div>

        <div class="form-group">
            <label class="form-label" for="admin_password_confirm">Confirm Password</label>
            <input type="password" class="form-input" id="admin_password_confirm" name="admin_password_confirm"
                   required minlength="8" autocomplete="new-password"
                   placeholder="Repeat password">
        </div>
    </div>

    <div class="security-notice">
        <h4>Password Requirements</h4>
        <p>
            &#8226; Minimum 8 characters<br>
            &#8226; Recommended: Mix of uppercase, lowercase, numbers, and symbols<br>
            &#8226; Do not use common passwords
        </p>
    </div>

    <div class="btn-group">
        <a href="?step=3" class="btn btn-secondary">&larr; Back</a>
        <button type="submit" class="btn btn-primary">
            Create Admin &rarr;
        </button>
    </div>
</form>

<script>
document.querySelector('form').addEventListener('submit', function(e) {
    const pass = document.getElementById('admin_password').value;
    const confirm = document.getElementById('admin_password_confirm').value;

    if (pass !== confirm) {
        e.preventDefault();
        alert('Passwords do not match!');
        return false;
    }

    if (pass.length < 8) {
        e.preventDefault();
        alert('Password must be at least 8 characters!');
        return false;
    }
});
</script>
