<?php

declare(strict_types=1);

use App\Admin\Auth;
use App\Env;
use App\Presentation\Controller\Api\ApiRouter;

require_once __DIR__ . '/../../vendor/autoload.php';
Env::bootstrap();

header('Content-Type: application/json; charset=utf-8');

try {
    Auth::requireAuth();

    $action = (string) ($_GET['action'] ?? '');
    $router = new ApiRouter();
    $response = $router->route($action);

    // Send response
    $response->send();

} catch (Throwable $e) {
    $rid = bin2hex(random_bytes(8));
    error_log('admin_api_error rid=' . $rid . ' type=' . get_class($e) . ' msg=' . $e->getMessage());
    header('X-Request-ID: ' . $rid);

    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Server error', 'request_id' => $rid], JSON_UNESCAPED_UNICODE);
}
