<?php

declare(strict_types=1);

namespace App\Domain\Domain;

/**
 * Domain repository interface
 *
 * Common contract for both global and user domain repositories
 */
interface DomainRepositoryInterface
{
    /**
     * Find domain by ID
     *
     * @param int $id
     * @return array<string, mixed>|null
     */
    public function findById(int $id): ?array;

    /**
     * Check if domain exists by name
     *
     * @param string $domain
     * @return bool
     */
    public function domainExists(string $domain): bool;

    /**
     * Delete domain by ID
     *
     * @param int $id
     * @return bool
     */
    public function deleteById(int $id): bool;
}
