<?php

declare(strict_types=1);

namespace App\Infrastructure\Persistence;

/**
 * Base repository interface for all repositories
 *
 * @template T of array
 */
interface RepositoryInterface
{
    /**
     * Find entity by ID
     *
     * @param int $id
     * @return T|null
     */
    public function findById(int $id): ?array;

    /**
     * Check if entity exists
     *
     * @param int $id
     * @return bool
     */
    public function existsById(int $id): bool;

    /**
     * Delete entity by ID
     *
     * @param int $id
     * @return bool
     */
    public function deleteById(int $id): bool;
}
