<?php

declare(strict_types=1);

namespace App\Presentation\Middleware;

use App\Infrastructure\Http\Request;
use App\Infrastructure\Http\Response;

/**
 * Middleware interface for request/response pipeline
 */
interface MiddlewareInterface
{
    /**
     * Process the request and return a response
     *
     * @param Request $request The incoming request
     * @param callable(Request): Response $next The next middleware in the pipeline
     * @return Response The response
     */
    public function handle(Request $request, callable $next): Response;
}
